/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	RotateAxes.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"


HRESULT RotateAxes(double angle=0.0, IDirection **retval1=NULL, IDirection **retval2 = NULL)
{
	// Rotates the axes and return the local axes
	START_METHOD("RotateAxes")

	HRESULT status = CONV_SUCCESS;
	
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IGeometric *geometric = CAST(IGeometric, activeWorkplane);

	// get the geometry
	IGeometry *pGeometry = NULL;
	status = geometric->GetGeometry(&pGeometry);
	CHECK_RETURN_STATUS(status)

	IPlane *plane = CAST(IPlane, pGeometry);

	IDirection *pDirection = NULL;
	status = plane->GetNormal(&pDirection);
	CHECK_RETURN_STATUS(status)

	IVector *pVecX = NULL;
	status = (GetCLASS(Vector))->CreateVector(1, 0, 0,&pVecX);
	CHECK_RETURN_STATUS(status)

	IVector *pVecY = NULL;
	status = (GetCLASS(Vector))->CreateVector(0, 1, 0,&pVecY);
	CHECK_RETURN_STATUS(status)	

	// Rotate with the angle
	IVector *pNewVecX = NULL;
	status = pVecX->Rotate(pDirection,angle,&pNewVecX);
	CHECK_RETURN_STATUS(status)

	// get elements

	double dElement0, dElement1, dElement2;
	status = pNewVecX->GetAt(0, &dElement0);
	CHECK_RETURN_STATUS(status)

	status = pNewVecX->GetAt(1, &dElement1);
	CHECK_RETURN_STATUS(status)

	status = pNewVecX->GetAt(2, &dElement2);
	CHECK_RETURN_STATUS(status)

	IDirection *pNewX = NULL;
	status = (GetCLASS(Direction))->CreateDirection(dElement0, dElement1, dElement2, &pNewX);
	CHECK_RETURN_STATUS(status)

	IVector *pNewVecY = NULL;
	status = pVecY->Rotate(pDirection, angle, &pNewVecY);
	CHECK_RETURN_STATUS(status)

	// get elements

	double dElement3, dElement4, dElement5;
	status = pNewVecY->GetAt(0, &dElement3);
	CHECK_RETURN_STATUS(status)

	status = pNewVecY->GetAt(1, &dElement4);
	CHECK_RETURN_STATUS(status)

	status = pNewVecY->GetAt(2, &dElement5);
	CHECK_RETURN_STATUS(status)

	IDirection *pNewY = NULL;

	status = (GetCLASS(Direction))->CreateDirection(dElement3, dElement4, dElement5, &pNewY);
	CHECK_RETURN_STATUS(status)

	// creatematrixdir
	IMatrix *pRotate = NULL;
	status = (GetCLASS(Matrix))->CreateRotationMatrix(pNewX, pNewY, &pRotate);
	CHECK_RETURN_STATUS(status)

	IVector *pLocalOrigin = NULL;
	status = activeWorkplane->GetLocalOrigin(&pLocalOrigin);
	CHECK_RETURN_STATUS(status)

	// multiply vectors

	IVector *pOrigin = NULL;
	status = pRotate->MultiplyByVector(pLocalOrigin, &pOrigin);
	CHECK_RETURN_STATUS(status)

	IDirection *pLocalOriginX= NULL;
	status = activeWorkplane->GetLocalX(&pLocalOriginX);
	CHECK_RETURN_STATUS(status)

	IDirection *pLocalOriginY = NULL;
	status = activeWorkplane->GetLocalY(&pLocalOriginY);
	CHECK_RETURN_STATUS(status)

	// Multiply direction for x
	IDirection *pLocalX = NULL;
    status = pRotate->MultiplyByDirection(pLocalOriginX, &pLocalX);
	CHECK_RETURN_STATUS(status)

	// Multiply direction for y
	IDirection *pLocalY = NULL;
    status = pRotate->MultiplyByDirection(pLocalOriginY, &pLocalY);
	CHECK_RETURN_STATUS(status)

	status = activeWorkplane->SetLocalOrigin(pOrigin);
	CHECK_RETURN_STATUS(status)

	// Set the Local Axes
	status = activeWorkplane->SetLocalAxes(pLocalX, pLocalY);
	CHECK_RETURN_STATUS(status)

	*retval1 = pLocalX;
	*retval2 = pLocalY;

	END_METHOD("RotateAxes")
}
